<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\EmailVerification;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\User\UserEmailVerificationTable;

final class UserEmailVerificationFinder extends AbstractFinder implements InterfaceUserEmailVerificationSetter
{
    /**
     * setter interface
     */
    use TraitUserEmailVerificationSetters;

    public function getTableName(): string
    {
        return UserEmailVerificationTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {UserEmailVerificationTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): UserEmailVerificationModel
    {
        return UserEmailVerificationModel::createFromUntouchedBean_noException(parent::pop());
    }
}
